package org.msh.tb.bd.tbforms.dhis2;

import org.msh.tb.application.tasks.TaskStatus;

/**
 * Created by Mauricio on 14/02/2017.
 * Exportation status used by the UI to display the right status of a task
 */
public enum ExportStatus {
    RUNNING,
    NOT_RUNNING,
    SUCCESS,
    ERROR;

    /**
     * Returns the corresponding ExportStatus of a TaskStatus
     * @param taskStatus
     * @return
     */
    public static ExportStatus convert(TaskStatus taskStatus){
        if (taskStatus == null) {
            return ExportStatus.NOT_RUNNING;
        }

        switch (taskStatus) {
            case FINISHED:
                return ExportStatus.SUCCESS;
            case ERROR:
                return ExportStatus.ERROR;
            case CANCELED:
                return ExportStatus.NOT_RUNNING;
            default:
                return ExportStatus.RUNNING;
        }
    }
}
